/**
 * Fecha de creacin: (23/08/2010)
 */   
package com.ejie.p06b.pdf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.pdf.xml.P06BPdtesEnvioDECXML;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BPdtesEnvioDECPDF implements P06BIPDF{
    private static long numeroPDF = 0;
	
	public String getXmlPdf(HttpServletRequest request){
    	String xmlPdf = null;
    	try {
    		/*
    		java.util.Date fechaHoy = new java.util.Date();
    		String ejercicio = "";
    		try{
    			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
    	   		ejercicio = simpleDateFormat.format(fechaHoy);
    		}catch(Exception e){
    			P06BLog.send(2,this.getClass().getName(),"Error obteniendo el ejercicio actual: " + e.toString());
    		}
    		*/
    		
    		//Obtener la where con los criterios de busqueda
	    	//String where = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
			//De momento NO hay pantalla de filtrado para mostrar este PDF, as que ponemos la where directamente.
    		
    		String ejerDEC = (request.getParameter("EjercicioPdtesDEC")==null)?"":request.getParameter("EjercicioPdtesDEC");
    		
    		//Sacar los que estn en activo en la base de datos a 31 de diciembre del ejercicio anterior.
    		//Sacar los que se encuentren de baja o suspensin actualmente pero que a 31 de diciembre del ejercico anterior se encontrasen activos - SI
    		//Sacar los que estan PENDIENTES de ENVIO, es decir, los que NO tienen registro en la tabla 32.
    		StringBuffer where = new StringBuffer("");
/*
    		where.append(" where " + P06BTablas.P06B_P06B20_CLASE + " <> '" + P06BConstantes.P06B_AGENTEVINCULADO_FISICA + "'");
    		where.append(" and " + P06BTablas.P06B_P06B20_CLASE + " <> '" + P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA + "'");
    		where.append(" and " + P06BTablas.P06B_P06B20_FECHAAL + " <= TO_DATE('31/12/"+(Integer.parseInt(ejercicio) - 1)+"', 'dd/mm/yyyy')");
    		where.append(" and (");
	    		where.append(" (" + P06BTablas.P06B_P06B20_ESTADO + " = 'A')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = 'R')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = 'B' and " + P06BTablas.P06B_P06B20_FECHABAJ + " >= TO_DATE('01/01/"+ejercicio+"', 'dd/mm/yyyy'))");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = 'S' and " + P06BTablas.P06B_P06B20_FECHASUS + " >= TO_DATE('01/01/"+ejercicio+"', 'dd/mm/yyyy'))");
    		where.append(" )");
    		where.append(" and " + P06BTablas.P06B_P06B20_NUMEXP + " not in (select " + P06BTablas.P06B_P06B32_NUMEXP + " from " +P06BTablas.P06B_P06B32T00_TABLA+ " where " + P06BTablas.P06B_P06B32_EJERCICIO + "='" +(Integer.parseInt(ejercicio) - 1)+ "')");		    	
  */
    		
    		//Si se trata de una DEC anterior al 2010, no obligar a los vinculados
    		//Si se trata de la DEC 2010 o posteriores, s obligar a los vinculados
    		if(Integer.parseInt(ejerDEC) < 2010){
    			where.append(" where " + P06BTablas.P06B_P06B20_CLASE + " <> '" + P06BConstantes.P06B_AGENTEVINCULADO_FISICA + "'");
        		where.append(" and " + P06BTablas.P06B_P06B20_CLASE + " <> '" + P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA + "'");
        		where.append(" and ");
    		}else{
    			where.append(" where ");
    		}
    		where.append(P06BTablas.P06B_P06B20_FECHAAL + " <= TO_DATE('31/12/"+(Integer.parseInt(ejerDEC))+"', 'dd/mm/yyyy')");
    		where.append(" and (");
	    		where.append(" (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_ALTA + "')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA + "')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_REVISION + "')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_BAJA + "' and " + 
	    				P06BTablas.P06B_P06B20_FECHABAJ + " >= TO_DATE('01/01/"+(Integer.parseInt(ejerDEC))+"', 'dd/mm/yyyy'))");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION + "' and " + 
	    				P06BTablas.P06B_P06B20_FECHASUS + " >= TO_DATE('01/01/"+(Integer.parseInt(ejerDEC))+"', 'dd/mm/yyyy'))");
    		where.append(" )");
    		where.append(" and " + P06BTablas.P06B_P06B20_NUMEXP + " not in (select " + P06BTablas.P06B_P06B32_NUMEXP + " from " +P06BTablas.P06B_P06B32T00_TABLA+ " where " + P06BTablas.P06B_P06B32_EJERCICIO + "='" +(Integer.parseInt(ejerDEC))+ "')");		    	
    		
    		P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "WHERE para el listado PDF: " + where.toString());
			
			//Obtener el listado de corredores que cumplen los criterios de bsqueda
    		//Nos vale el mismo mtodo que se utiliza para imprimir el PDF del listado de la bsqueda
			ArrayList corredoresPdtesEnvioDEC = P06BCorredoresManager.getInstance().selectCorredoresListadoBusqueda(where.toString());
					
			//Obtenemos el XML a partir de los datos
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Antes de obtener el XML de datos");
			xmlPdf = P06BPdtesEnvioDECXML.getXml(corredoresPdtesEnvioDEC, request);
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Despues de obtener el XML de datos");
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Error al obtener el XML: " + e.getMessage());
			return null;
		}
    	
		return xmlPdf;
    }
    
    public String getXsltFichero(HttpServletRequest request){
    	String xsltFichero = null;
    	try {
			//Obtener el idioma
			String idioma = null;
			P06BPerfilUsuario perfilUsuario = (P06BPerfilUsuario) request.getSession().getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);
			if (perfilUsuario != null){
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Existe objeto perfilUsuario");
				idioma = perfilUsuario.getIdIdioma();
			}else{
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "NOOOOOO Existe objeto perfilUsuario");
			}
			if (idioma == null || idioma.equals("") ){
				idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
			}
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Idioma: "+idioma);
			
			//De momento solo est en castellano
			xsltFichero = P06BParametros.getListado("pdf.xsl.listadoPdtesEnvioDEC_"+idioma);
			
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Error al obtener el nombre del xslt: " + e.getMessage());
			return null;
		}
    	return xsltFichero;
    }
	
}